/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class LightStick
extends Block {
    private boolean compiled = false;
    private int squareid3D = 0;
    private float blockrenderwidth = 16.0f;

    public LightStick(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.alwaysRender = true;
        this.hasOwnRenderer = true;
        this.brightness = 0.75f;
        this.maxdamage = 1;
        this.randomtick = true;
        this.burntime = 30;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        int meta = w.getblockmeta(d, x, y, z);
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y, z) != this.blockID) {
            return;
        }
        switch (meta >> 8) {
            case 1: {
                bid = w.getblock(d, x, y, z - 1);
                break;
            }
            case 2: {
                bid = w.getblock(d, x, y, z + 1);
                break;
            }
            case 3: {
                bid = w.getblock(d, x + 1, y, z);
                break;
            }
            case 4: {
                bid = w.getblock(d, x - 1, y, z);
                break;
            }
            case 5: {
                bid = w.getblock(d, x, y + 1, z);
                break;
            }
            default: {
                bid = w.getblock(d, x, y - 1, z);
            }
        }
        if (!Blocks.isSolid(bid)) {
            if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                return;
            }
            w.setblock(d, x, y, z, 0);
            EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (e != null) {
                e.fill(this, 1);
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        Utils.spawnParticlesFromServer(w, "DangerZone:ParticleFire", w.rand.nextInt(3) + 3, d, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        int brw = (int)(this.blockrenderwidth / 2.0f);
        st = builder.findVBOtextureforblockside(0, bid);
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            switch (meta >> 8) {
                case 1: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    break;
                }
                case 2: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    break;
                }
                case 3: {
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    break;
                }
                case 4: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    break;
                }
                case 5: {
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    break;
                }
                default: {
                    v.addVertexInfoToVBO(brw + xo, brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, -brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmin, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(-brw + xo, -brw + yo, brw + zo, st.xoffsetmin, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                    v.addVertexInfoToVBO(brw + xo, -brw + yo, -brw + zo, st.xoffsetmax, st.yoffsetmax, builder.cbr, builder.cbg, builder.cbb);
                }
            }
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            this.squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)this.squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(8 * stride);
            LightStick.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, this.blockrenderwidth / 2.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            LightStick.addVertexInfoToBuffer(vbodata, this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, -this.blockrenderwidth / 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            this.compiled = true;
        }
        MatrixStack.pushMatrix();
        switch (meta >> 8) {
            case 1: {
                MatrixStack.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                MatrixStack.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case 3: {
                MatrixStack.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 4: {
                MatrixStack.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 5: {
                MatrixStack.rotate(180.0f, 1.0f, 0.0f, 0.0f);
            }
        }
        MatrixStack.sendCurrentStack();
        wr.loadtextureforblockside(0, bid, false);
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)8);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        MatrixStack.popMatrix();
    }

    @Override
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return false;
        }
        if (Blocks.isLeaves(focusbid)) {
            return false;
        }
        if (!Blocks.isSolidThisSide(focusbid, w, dimension, x, y, z, side)) {
            return false;
        }
        if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0)) {
            return false;
        }
        switch (side) {
            case 0: {
                w.setblockandmeta(dimension, x, y + 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y + 1, z);
                break;
            }
            case 1: {
                w.setblockandmeta(dimension, x, y, z + 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z + 1);
                break;
            }
            case 2: {
                w.setblockandmeta(dimension, x, y, z - 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z - 1);
                break;
            }
            case 3: {
                w.setblockandmeta(dimension, x - 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x - 1, y, z);
                break;
            }
            case 4: {
                w.setblockandmeta(dimension, x + 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x + 1, y, z);
                break;
            }
            case 5: {
                w.setblockandmeta(dimension, x, y - 1, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y - 1, z);
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        return true;
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }
}

